/////////////////////////////////////////////////////////////
// CINEMA SDK : MENU PLUGINS															 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

// example code for a menu plugin and multiprocessing

#include "c4d.h"
#include "c4d_symbols.h"


class MPTest : public Thread
{
	public:
		Random	rnd;
		LONG		start;
		Real		result;
		
		virtual void Main(void);
};

void MPTest::Main(void)
{
	// calculate the 10,000,000 th random number

	rnd.Init(start);

	LONG i;
	for (i=0; i<10000000; i++)
		rnd.Get01();

	result=rnd.Get01();
}

class ControlThread : public Thread
{
	public:
		virtual void Main(void);
};

void ControlThread::Main(void)
{
	GeShowMouse(MOUSE_BUSY);

	MPThread	mp;
	LONG			i,cnt=GeGetCPUCount(); 
	MPTest		thread[MAX_THREADS];
	Thread		*list[MAX_THREADS];

	for (i=0; i<cnt; i++)
	{
		thread[i].start=i;
		thread[i].result=0.0;
		list[i]=&thread[i];
	}
	
	if (!mp.Init(*this,cnt,list)) return;
	if (!mp.Start()) return;

	mp.Wait();
	
	String str="Multiprocessing Test on "+LongToString(cnt)+" CPUs:";
	for (i=0; i<cnt; i++)
		str+=" "+RealToString(thread[i].result);

	GeShowMouse(MOUSE_NORMAL);

	MessageDialog(str);
}

class MenuTest : public CommandData
{
	public:
		virtual Bool Execute(BaseDocument *doc);
};

Bool MenuTest::Execute(BaseDocument *doc)
{
	ControlThread ct;
	ct.Start(FALSE); // multiprocessing test
	return TRUE;
}

Bool RegisterMenuTest(void)
{
	// decide by name if the plugin shall be registered - just for user convenience
	String name=GeLoadString(IDS_MENUTEST); if (!name.Content()) return TRUE;
	// be sure to use a unique ID obtained from www.plugincafe.com
	return RegisterCommandPlugin(1000956,name,0,"icon.tif","C++ SDK Menu Test Plugin",gNew MenuTest);
}

